/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms;

import com.badlogic.gdx.math.GridPoint2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.RoomTile;

public class StockpileComponent {
    private final Map<GridPoint2, RoomTile> roomTiles;
    private final long parentRoomId;
    private final Map<GridPoint2, ItemAllocation> allocations;

    public StockpileComponent(Map<GridPoint2, RoomTile> roomTiles, long parentRoomId) {
        this.roomTiles = roomTiles;
        this.parentRoomId = parentRoomId;
        this.allocations = new HashMap<GridPoint2, ItemAllocation>();
    }

    public void itemPickedUp(GridPoint2 position, int quantityRemoved, ItemEntityAttributes attributes) {
        ItemAllocation allocationAtTile = this.getAllocationAt(position.x, position.y);
        if (allocationAtTile != null && allocationAtTile.getQuantity() >= quantityRemoved && allocationAtTile.getGameMaterial().equals(attributes.getMaterial(attributes.getItemType().getPrimaryMaterialType())) && allocationAtTile.getItemType().equals(attributes.getItemType())) {
            allocationAtTile.setQuantity(allocationAtTile.getQuantity() - quantityRemoved);
            if (allocationAtTile.getQuantity() <= 0) {
                this.allocations.remove(position);
            }
        }
    }

    public ItemAllocation allocate(Entity item, TiledMap map) {
        ItemEntityAttributes attributes = (ItemEntityAttributes)item.getPhysicalEntityComponent().getAttributes();
        ItemType itemType = attributes.getItemType();
        int maxStackSize = itemType.getMaxStackSize();
        GameMaterial itemMaterial = attributes.getMaterial(attributes.getItemType().getPrimaryMaterialType());
        ItemAllocation allocationToUse = null;
        ArrayList<GridPoint2> pointsToTraverse = new ArrayList<GridPoint2>(this.roomTiles.keySet());
        for (GridPoint2 position : pointsToTraverse) {
            ItemEntityAttributes attributesItemInTile;
            MapTile tileAtPosition = map.getTile(position);
            ItemAllocation allocationAtPosition = this.allocations.get(position);
            if (allocationAtPosition == null) {
                if (tileAtPosition.isEmpty()) {
                    allocationToUse = new ItemAllocation();
                    allocationToUse.setTargetPosition(position);
                    allocationToUse.setItemType(attributes.getItemType());
                    allocationToUse.setGameMaterial(itemMaterial);
                    allocationToUse.setQuantity(0);
                    allocationToUse.setTargetType(ItemAllocation.AllocationTargetType.ROOM);
                    allocationToUse.setTargetId(this.parentRoomId);
                    this.allocations.put(position, allocationToUse);
                    break;
                }
                Entity itemAlreadyInTile = tileAtPosition.getFirstItem();
                if (itemAlreadyInTile == null) continue;
                allocationAtPosition = new ItemAllocation();
                ItemEntityAttributes attributesItemAlreadyInTile = (ItemEntityAttributes)itemAlreadyInTile.getPhysicalEntityComponent().getAttributes();
                allocationAtPosition.setQuantity(attributesItemAlreadyInTile.getQuantity());
                allocationAtPosition.setGameMaterial(attributesItemAlreadyInTile.getMaterial(attributesItemAlreadyInTile.getItemType().getPrimaryMaterialType()));
                allocationAtPosition.setItemType(attributesItemAlreadyInTile.getItemType());
                allocationAtPosition.setTargetPosition(position);
                allocationAtPosition.setTargetType(ItemAllocation.AllocationTargetType.ROOM);
                allocationAtPosition.setTargetId(this.parentRoomId);
                this.allocations.put(position, allocationAtPosition);
                continue;
            }
            if (!allocationAtPosition.getItemType().equals(attributes.getItemType()) || !allocationAtPosition.getGameMaterial().equals(itemMaterial) || allocationAtPosition.getQuantity() >= maxStackSize || !this.containsSameType(tileAtPosition, allocationAtPosition)) continue;
            Entity itemInTile = tileAtPosition.getFirstItem();
            if (itemInTile != null && (attributesItemInTile = (ItemEntityAttributes)itemInTile.getPhysicalEntityComponent().getAttributes()).getQuantity() > allocationAtPosition.getQuantity()) {
                allocationAtPosition.setQuantity(attributesItemInTile.getQuantity());
            }
            allocationToUse = allocationAtPosition;
            break;
        }
        if (allocationToUse != null) {
            ItemAllocation allocationToReturn = allocationToUse.clone();
            int quantityToAllocate = Math.min(itemType.getMaxHauledAtOnce(), maxStackSize - allocationToUse.getQuantity());
            if (quantityToAllocate == 0) {
                return null;
            }
            allocationToUse.setQuantity(allocationToUse.getQuantity() + quantityToAllocate);
            allocationToReturn.setQuantity(quantityToAllocate);
            allocationToReturn.setItemEntityId(item.getId());
            attributes.setNumAllocated(attributes.getNumAllocated() + quantityToAllocate);
            return allocationToReturn;
        }
        return null;
    }

    private boolean containsSameType(MapTile tileAtPosition, ItemAllocation allocationAtPosition) {
        Entity itemAtPosition = null;
        for (Entity entity : tileAtPosition.getEntities()) {
            if (entity.getType().equals((Object)EntityType.PLANT)) {
                return false;
            }
            if (!entity.getType().equals((Object)EntityType.ITEM)) continue;
            itemAtPosition = entity;
            break;
        }
        if (itemAtPosition == null) {
            return true;
        }
        ItemEntityAttributes attributes = (ItemEntityAttributes)itemAtPosition.getPhysicalEntityComponent().getAttributes();
        return attributes.getItemType().equals(allocationAtPosition.getItemType()) && attributes.getMaterial(attributes.getItemType().getPrimaryMaterialType()).equals(allocationAtPosition.getGameMaterial());
    }

    public void allocationCancelled(ItemAllocation allocation) {
        ItemAllocation positionalAllocation = this.allocations.get(allocation.getTargetPosition());
        if (positionalAllocation == null) {
            return;
        }
        if (!positionalAllocation.getGameMaterial().equals(allocation.getGameMaterial()) || !positionalAllocation.getItemType().equals(allocation.getItemType())) {
            System.err.println(this.getClass().getSimpleName() + " received incorrect allocation cancelled message, find out why");
            return;
        }
        positionalAllocation.setQuantity(positionalAllocation.getQuantity() - allocation.getQuantity());
        if (positionalAllocation.getQuantity() <= 0) {
            this.allocations.remove(allocation.getTargetPosition());
        }
    }

    public ItemAllocation getAllocationAt(int tileX, int tileY) {
        return this.allocations.get(new GridPoint2(tileX, tileY));
    }
}

